/********************************************
; File: QDAux.h
;
;
; Copyright Apple Computer, Inc.1986-90
; All Rights Reserved
;
********************************************/
#ifndef __TYPES__
#include <TYPES.h>
#endif

#ifndef __QUICKDRAW__
#include <QUICKDRAW.h>
#endif

#ifndef __QDAUX__
#define __QDAUX__


/*
    PicInfo - The following picture
    opcodes are for reference only!!
*/

#define frameVerb 0x00
#define picNop 0x00
#define drawCharVerb 0x00
#define paintVerb 0x01
#define picClipRgn 0x01
#define drawTextVerb  0x01
#define eraseVerb 0x02
#define picBkPat 0x02
#define drawCStrVerb 0x02
#define invertVerb 0x03
#define picTxFont 0x03
#define fillVerb 0x04
#define picTxFace 0x04
#define picTxMode 0x05
#define picSpExtra 0x06
#define picPnSize 0x07
#define picPnMode 0x08
#define picPnPat 0x09
#define picThePat 0x0A
#define picFillPat 0x0A  /* 10 */  /* Please use picThePat */
#define picOvSize 0x0B
#define picOrigin 0x0C
#define picTxSize 0x0D
#define picFGColor 0x0E
#define picBGColor 0x0F
#define picTxRatio 0x10
#define picVersion 0x11
#define picChExtra 0x12  /* 18 */
#define picPnMask 0x13  /* 19 */
#define picArcRot 0x14  /* 20 */
#define picFontFlags 0x15  /* 21 */
#define lineNoun 0x20
#define picLine 0x20
#define picLineFrom 0x21
#define picShortL 0x22
#define picShortLine 0x22  /* 34 */
#define picShortLFrom 0x23
#define picLongText 0x28
#define picDHText 0x29
#define picDVText 0x2A
#define picDVDHText 0x2B
#define rectNoun 0x30
#define rRectNoun 0x40
#define ovalNoun 0x50
#define arcNoun 0x60
#define polyNoun 0x70
#define rgnNoun 0x80
#define mapNoun 0x90
#define picBitsRect 0x90
#define picBitsRgn 0x91
#define picPBitsRect 0x98
#define picPBitsRgn 0x99
#define picShortComment 0xA0
#define picLongComment 0xA1
#define picEnd 0xFF

/* SeedFill/CalcMask Masks */
#define resMode640PMask 0x00
#define resMode640DMask 0x01
#define resMode320Mask 0x02
#define destModeCopyMask 0x0000
#define destModeLeaveMask 0x1000
#define destModeOnesMask 0x2000
#define destModeClrToZeros 0x2000  /* 8192 */
#define destModeZerosMask 0x3000
#define destModeClrToOnes 0x3000  /* 12288 */

/* Error Codes */
#define badRectSize 0x1211
#define destModeError 0x1212

/* Other Constants */
#define fTextJust 0x0008
struct QDIconRecord {
   Word iconType; /*   */
   Word iconSize; /*   */
   Word iconHeight; /*   */
   Word iconWidth; /*   */
   Byte iconImage[1]; /*   */
   Byte iconMask[1]; /*   */
} ;
typedef struct QDIconRecord QDIconRecord, *QDIconRecordPtr, **QDIconRecordHndl;
struct Picture {
   Word picSCB;
   Rect picFrame;
   Word pVersion; /* Followed by picture opcodes  */
} ;
typedef struct Picture Picture, *PicPtr, **PicHndl;
struct LeakTable {
   Word leakCount; /*   */
   Word leakColors[16]; /*   */
} ;
typedef struct LeakTable LeakTable, *LeakTablePtr;
extern pascal void CalcMask() inline(0x0E12,dispatcher);
extern pascal void ClosePicture() inline(0xB904,dispatcher);
extern pascal void CopyPixels() inline(0x0912,dispatcher);
extern pascal void DrawIcon() inline(0x0B12,dispatcher);
extern pascal void DrawPicture() inline(0xBA04,dispatcher);
extern pascal void KillPicture() inline(0xBB04,dispatcher);
extern pascal PicHndl OpenPicture() inline(0xB704,dispatcher);
extern pascal void PicComment() inline(0xB804,dispatcher);
extern pascal void QDAuxBootInit() inline(0x0112,dispatcher);
extern pascal void QDAuxReset() inline(0x0512,dispatcher);
extern pascal void QDAuxShutDown() inline(0x0312,dispatcher);
extern pascal void QDAuxStartUp() inline(0x0212,dispatcher);
extern pascal Boolean QDAuxStatus() inline(0x0612,dispatcher);
extern pascal Word QDAuxVersion() inline(0x0412,dispatcher);
extern pascal void SeedFill() inline(0x0D12,dispatcher);
extern pascal void SpecialRect() inline(0x0C12,dispatcher);
extern pascal void WaitCursor() inline(0x0A12,dispatcher);
#endif
